package eu.dnetlib.msro.openaireplus.workflows.nodes.stats;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;

/**
 * Ask the StatsManagerService to promote the shadow cache so that its entries can be used by the portal specified by the additional BB
 * parameter <code>StatsManagerServiceBBAction.PROMOTE_SHADOW_CACHE.getPortalParamName()</code>.
 * 
 * @author alessia
 * 
 */
public class PromoteShadowCacheStatsJobNode extends AbstractStatsJobNode {

	private static final Log log = LogFactory.getLog(PromoteShadowCacheStatsJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction(StatsManagerServiceBBAction.PROMOTE_SHADOW_CACHE.action());
		String portal = getTargetPortal(token);
		if (StringUtils.isNotBlank(portal)) {
			job.getParameters().put(StatsManagerServiceBBAction.PROMOTE_SHADOW_CACHE.getPortalParamName(), portal);
		} else {
			log.warn(StatsManagerServiceBBAction.PROMOTE_SHADOW_CACHE.getPortalParamName() + " not set. The StatsManagerService will use its default.");
		}
	}

}
