package eu.dnetlib.msro.openaireplus.workflows.nodes.actions;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class CleanActionSetsProfileJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(CleanActionSetsProfileJobNode.class);

	@Resource
	private UniqueServiceLocator serviceLocator;

	private String xupdate;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		log.info("updating Action Sets profiles: " + getXupdate());
		serviceLocator.getService(ISRegistryService.class).executeXUpdate(getXupdate());
		return Arc.DEFAULT_ARC;
	}

	public String getXupdate() {
		return xupdate;
	}

	@Required
	public void setXupdate(final String xupdate) {
		this.xupdate = xupdate;
	}

}
