package eu.dnetlib.msro.openaireplus.workflows.nodes.stats;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;

/**
 * Ask the StatsManagerService to restore the cache of the portal specified by the additional BB parameter
 * <code>StatsManagerServiceBBAction.RESTORE_CACHE.getPortalParamName()</code> to the last available backup.
 * <p>
 * To create a backup you must send a "backup" BB message.
 * </p>
 * 
 * @see eu.dnetlib.msro.openaireplus.workflows.nodes.stats.BackupStatsCacheJobNode
 * @author alessia
 * 
 */
public class RestoreStatsCacheJobNode extends AbstractStatsJobNode {

	private static final Log log = LogFactory.getLog(RestoreStatsCacheJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction(StatsManagerServiceBBAction.RESTORE_CACHE.action());
		String portal = getTargetPortal(token);
		if (StringUtils.isNotBlank(portal)) {
			job.getParameters().put(StatsManagerServiceBBAction.RESTORE_CACHE.getPortalParamName(), portal);
		} else {
			log.warn(StatsManagerServiceBBAction.RESTORE_CACHE.getPortalParamName() + " not set. The StatsManagerService will use its default.");
		}
	}

}
