package eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby;

import java.io.StringReader;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

// TODO: Auto-generated Javadoc
/**
 * The Class FindHostedByJonbNode.
 */
public class FindHostedByJonbNode extends SimpleJobNode {

	/** The input epr param. */
	private String inputEprParam;

	/** The output epr param. */
	private String outputEprParam;

	/** The counters param. */
	private String countersParam;

	/** The result set client factory. */
	private ResultSetClientFactory resultSetClientFactory;

	/** The mapped result set factory. */
	private MappedResultSetFactory mappedResultSetFactory;

	private final String unknown_repo_id = "openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18";

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.msro.workflows.nodes.SimpleJobNode#execute(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String execute(final NodeToken token) throws Exception {
		final W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(inputEprParam));
		final HostedByCounters counters = new HostedByCounters();

		final SAXReader reader = new SAXReader();

		final UnaryFunction<String, String> hostedByMapFunction = new UnaryFunction<String, String>() {

			@Override
			public String evaluate(final String input) {
				try {
					final Document doc = reader.read(new StringReader(input));
					final Element node = (Element) doc.selectSingleNode("//*[local-name()='hostedBy']");
					if (node != null) {
						String hostedById = node.attributeValue("id");
						if (!hostedById.equals(unknown_repo_id)) {
							counters.increaseCounter(hostedById);
						}
					}
				} catch (Exception e) {

				}

				return input;
			}
		};

		final W3CEndpointReference epr = mappedResultSetFactory.createMappedResultSet(inputEpr, hostedByMapFunction);
		token.getEnv().setAttribute(outputEprParam, epr.toString());
		token.getEnv().setTransientAttribute(getCountersParam(), counters);

		return Arc.DEFAULT_ARC;
	}

	/**
	 * @return the inputEprParam
	 */
	public String getInputEprParam() {
		return inputEprParam;
	}

	/**
	 * @param inputEprParam
	 *            the inputEprParam to set
	 */
	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	/**
	 * @return the outputEprParam
	 */
	public String getOutputEprParam() {
		return outputEprParam;
	}

	/**
	 * @param outputEprParam
	 *            the outputEprParam to set
	 */
	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	/**
	 * @return the resultSetClientFactory
	 */
	public ResultSetClientFactory getResultSetClientFactory() {
		return resultSetClientFactory;
	}

	/**
	 * @param resultSetClientFactory
	 *            the resultSetClientFactory to set
	 */
	public void setResultSetClientFactory(final ResultSetClientFactory resultSetClientFactory) {
		this.resultSetClientFactory = resultSetClientFactory;
	}

	/**
	 * @return the mappedResultSetFactory
	 */
	public MappedResultSetFactory getMappedResultSetFactory() {
		return mappedResultSetFactory;
	}

	/**
	 * @param mappedResultSetFactory
	 *            the mappedResultSetFactory to set
	 */
	public void setMappedResultSetFactory(final MappedResultSetFactory mappedResultSetFactory) {
		this.mappedResultSetFactory = mappedResultSetFactory;
	}

	/**
	 * @return the countersParam
	 */
	public String getCountersParam() {
		return countersParam;
	}

	/**
	 * @param countersParam
	 *            the countersParam to set
	 */
	public void setCountersParam(final String countersParam) {
		this.countersParam = countersParam;
	}

}
