--DATACITE API
INSERT INTO api (_dnet_resource_identifier_, id, protocolclass, datasource, typologyclass, compatibilityclass) VALUES ('api_________::datacite::oaisets', 'api_________::datacite::oaisets', 'oai_sets', 'openaire____::datacite', 'aggregator::datarepository', 'native');
INSERT INTO apicollections (param, original, api) VALUES ('baseUrl', 'http://oai.datacite.org/oai', 'api_________::datacite::oaisets');
INSERT INTO apicollections (param, original, api, accessparam) VALUES ('metadata_identifier_path', '//*[local-name() = ''setSpec'']', 'api_________::datacite::oaisets', false);

--FCT ENTITY REGISTRY
INSERT INTO organizations (_dnet_resource_identifier_, id, legalshortname, legalname, websiteurl, logourl, countryclass, provenanceactionclass) VALUES ('fct_________::FCT', 'fct_________::FCT', 'FCT', 'Fundação para a Ciência e a Tecnologia, I.P.', 'http://www.fct.pt', 'http://www.fct.pt/images/FCT_H_color_v2011_b.png', 'PT', 'sysimport:crosswalk:entityregistry');
INSERT INTO datasources (_dnet_resource_identifier_, id, officialname, englishname, websiteurl, logourl, contactemail, latitude, longitude, timezone, namespaceprefix, collectedfrom, datasourceclass) VALUES ('openaire____::fct', 'openaire____::fct', 'FCT - Fundação para a Ciência e a Tecnologia', 'FCT - Foundation for Science and Technology', 'http://www.fct.pt', 'http://www.fct.pt/images/FCT_H_color_v2011_b.png', 'projectos@fct.pt', 38.71, -9.14, 0.0, 'fct_________', 'infrastruct_::openaire', 'entityregistry');
INSERT INTO api (_dnet_resource_identifier_, id, protocolclass, datasource, typologyclass, compatibilityclass) VALUES ('api_________::fct::0', 'api_________::fct::0', 'filesystem', 'openaire____::fct', 'entityregistry', 'native');
INSERT INTO apicollections (param, original, api) VALUES ('baseUrl', 'file:///var/lib/dnet/fct', 'api_________::fct::0');
INSERT INTO apicollections (param, original, api) VALUES ('extensions', '*.xml', 'api_________::fct::0');
INSERT INTO apicollections (param, original, api, accessparam) VALUES ('metadata_identifier_path', '/project/id', 'api_________::fct::0', false);
UPDATE apicollections SET _dnet_resource_identifier_ = api||'@@'||param;
INSERT INTO datasource_organization (_dnet_resource_identifier_, datasource, organization) VALUES ('fct_________::fct@@fct_________::FCT', 'openaire____::fct', 'fct_________::FCT');


--DOAJ ENTITY REGISTRY
insert into datasources(id, officialname, englishname,  websiteurl, logourl,namespaceprefix,collectedfrom, datasourceclass,aggregator, _dnet_resource_identifier_ ) values ('openaire____::doaj', 'DOAJ-Journals', 'DOAJ-Journals','http://doaj.org/',  'http://doaj.org/static/doaj/images/logo_cropped.jpg','doaj_journal','infrastruct_::openaire', 'entityregistry','OPENAIRE','openaire____::doaj');
insert into api values ('api_________::doaj::0' ,'httpCSV','dnet:protocols', 'openaire____::doaj', 'api_________::doaj::0','metadata','dnet:content_description_typologies',false,false, 'entityregistry' ,'dnet:datasource_typologies', 'native','dnet:compatibilityLevel');
insert into apicollections(param,original,api,_dnet_resource_identifier_,accessparam) values('baseUrl', 'http://doaj.org/csv', 'api_________::doaj::0','api_________::doaj::0@@baseUrl',true);
insert into apicollections(param,original,api,_dnet_resource_identifier_,accessparam) values('separator', ',', 'api_________::doaj::0','api_________::doaj::0@@separator',true);
insert into apicollections(param,original,api,_dnet_resource_identifier_,accessparam) values('quote', '"', 'api_________::doaj::0','api_________::doaj::0@@quote',true);
insert into apicollections(param,original,api,_dnet_resource_identifier_,accessparam) values('identifier', 'ISSN', 'api_________::doaj::0','api_________::doaj::0@@identifier',true);
insert into apicollections(param,original,api,_dnet_resource_identifier_,accessparam) values('metadata_identifier_path', '//column[./@isID=''true'']', 'api_________::doaj::0','api_________::doaj::0@@metadata_identifier_path',false);


CREATE TABLE IF NOT EXISTS hostedby_map (
	_dnet_resource_identifier_ character varying(2048) DEFAULT 'temp_'||md5(clock_timestamp()::text)||'_'||md5(random()::text),
	oa_source_id               character varying(255) references  datasources(id),
	entry                      character varying(255) NOT NULL,
	datasourceid               character varying(255) references datasources(id),
  PRIMARY key(oa_source_id, entry)
);

