/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import org.apache.commons.lang.StringUtils;

public class SwitchIndexJobNode
extends BlackboardJobNode {
    private static final String BB_ACTION_SWITCH_INDEX = "UpdateIndex";
    private String inputIndexIdParam;
    private String outputIndexIdParam;
    private String xqueryForServiceIdParam;

    protected String obtainServiceId(NodeToken token) {
        String xquery = token.getEnv().getAttribute(this.getXqueryForServiceIdParam());
        try {
            return ((ISLookUpService)this.getServiceLocator().getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
        }
        catch (ISLookUpException e) {
            throw new RuntimeException("Service id not found using query: " + xquery, e);
        }
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        job.setAction(BB_ACTION_SWITCH_INDEX);
        String indexId = token.getEnv().getAttribute(this.getInputIndexIdParam());
        this.checkParam(this.getInputIndexIdParam(), "output indexId param is missing");
        this.checkParam(indexId, "indexId is required to perform switch");
        job.getParameters().put(this.getOutputIndexIdParam(), indexId);
    }

    private void checkParam(String param, String msg) throws MSROException {
        if (StringUtils.isBlank((String)param)) {
            throw new MSROException(msg);
        }
    }

    public String getInputIndexIdParam() {
        return this.inputIndexIdParam;
    }

    public void setInputIndexIdParam(String inputIndexIdParam) {
        this.inputIndexIdParam = inputIndexIdParam;
    }

    public String getOutputIndexIdParam() {
        return this.outputIndexIdParam;
    }

    public void setOutputIndexIdParam(String outputIndexIdParam) {
        this.outputIndexIdParam = outputIndexIdParam;
    }

    public String getXqueryForServiceIdParam() {
        return this.xqueryForServiceIdParam;
    }

    public void setXqueryForServiceIdParam(String xqueryForServiceIdParam) {
        this.xqueryForServiceIdParam = xqueryForServiceIdParam;
    }
}

