/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;

public class FindExistingRepositoriesJobNode
extends SimpleJobNode {
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String existingReposParam = "existingRepos";

    protected String execute(NodeToken token) throws Exception {
        String xquery = "for $x in /*[.//RESOURCE_TYPE/@value='RepositoryServiceResourceType'] return concat ($x//RESOURCE_IDENTIFIER/@value, '@@@', $x//RESOURCE_KIND/@value, '@@@', $x//EXTRA_FIELDS/FIELD[./key='OpenAireDataSourceId']/value)";
        List list = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery);
        HashMap map = Maps.newHashMap();
        for (String s : list) {
            String[] arr = s.split("@@@");
            if (arr.length != 3) continue;
            map.put(arr[2], new RepositoryInfo(arr[1], arr[0]));
        }
        token.getEnv().setTransientAttribute(this.getExistingReposParam(), (Object)map);
        return Arc.DEFAULT_ARC;
    }

    public String getExistingReposParam() {
        return this.existingReposParam;
    }

    public void setExistingReposParam(String existingReposParam) {
        this.existingReposParam = existingReposParam;
    }

    class RepositoryInfo {
        public String resourceKind;
        public String repoId;

        public RepositoryInfo(String resourceKind, String repoId) {
            this.resourceKind = resourceKind;
            this.repoId = repoId;
        }

        public String toString() {
            return "[" + this.resourceKind + ", " + this.repoId + "]";
        }
    }
}

