package eu.dnetlib.msro.openaireplus.workflows.nodes.stats;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;

/**
 * Ask the StatsManagerService to perform the content validation between the stats db and the preproduction index (using the prepublic
 * search service) and creates a report, which is serialized in the blackboard job parameters.
 * 
 * @author alessia
 * 
 */
public class ValidateShadowStatsJobNode extends BlackboardJobNode {

	private String xqueryForServiceIdParam;

	@Override
	protected String getXqueryForServiceId(final NodeToken token) {
		return token.getEnv().getAttribute(getXqueryForServiceIdParam());
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction(StatsManagerServiceBBAction.VALIDATE_SHADOW_STATS.action());
	}

	public String getXqueryForServiceIdParam() {
		return xqueryForServiceIdParam;
	}

	public void setXqueryForServiceIdParam(final String xqueryForServiceIdParam) {
		this.xqueryForServiceIdParam = xqueryForServiceIdParam;
	}

}
