package eu.dnetlib.msro.openaireplus.workflows.nodes.stats;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;

/**
 * Ask the StatsManagerService to refresh the shadow portal cache according to the content of the shadow stats db.
 * 
 * @author alessia
 * 
 */
public class PromoteShadowStatsJobNode extends BlackboardJobNode {

	private String xqueryForServiceIdParam;

	@Override
	protected String getXqueryForServiceId(final NodeToken token) {
		return token.getEnv().getAttribute(getXqueryForServiceIdParam());
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction(StatsManagerServiceBBAction.PROMOTE_SHADOW_STATS.action());
	}

	public String getXqueryForServiceIdParam() {
		return xqueryForServiceIdParam;
	}

	public void setXqueryForServiceIdParam(final String xqueryForServiceIdParam) {
		this.xqueryForServiceIdParam = xqueryForServiceIdParam;
	}

}
