package eu.dnetlib.msro.openaireplus.workflows.nodes.datacite;

import java.io.StringReader;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import eu.dnetlib.miscutils.functional.UnaryFunction;

public class PatchHostedBy implements UnaryFunction<String, String> {
	private Map<String, HostedByEntry> setSpecHostedByMap;
	private DataciteHostedByCounters counters;

	private final SAXReader reader = new SAXReader();
	private static final Log log = LogFactory.getLog(PatchHostedBy.class);

	public PatchHostedBy(final Map<String, HostedByEntry> setSpecHostedByMap, final DataciteHostedByCounters counters) {
		this.setSpecHostedByMap = setSpecHostedByMap;
		this.counters = counters;
		if (log.isDebugEnabled()) {
			log.debug("****************************************");
			log.debug("SetSpec/hostedBy map:");
			for (Map.Entry<String, HostedByEntry> e : setSpecHostedByMap.entrySet()) {
				log.debug("   " + e.getKey() + " -> " + e.getValue());
			}
			log.debug("****************************************");
		}
	}
	
	@Override
	public String evaluate(final String record) {
		try {
			final Document doc = reader.read(new StringReader(record));
			final Element node = (Element) doc.selectSingleNode("//*[local-name()='hostedBy']");
			if (node != null) {
				final HostedByEntry ds = findHostedBy(doc);
				if (ds != null) {	
					node.addAttribute("id", ds.getId());
					node.addAttribute("name", ds.getName());
					counters.increaseCounter(ds.getId());
				}
				return doc.asXML();
			} else if (log.isDebugEnabled()) {
				log.debug(" -- Missing hostedBy --");
			}
		} catch(Throwable e) {
			log.error("Error adding hosted by to " + record);
		}
		return record;
	}
	
	private HostedByEntry findHostedBy(final Document doc) {
		for(Object o : doc.selectNodes("//*[local-name()='header']/*[local-name()='setSpec']")) {
			final String set = ((Element) o).getText().trim();
			if (setSpecHostedByMap.containsKey(set)) {
				if (log.isInfoEnabled()) {
					log.info(set + " -> " + setSpecHostedByMap.get(set));
				}
				return setSpecHostedByMap.get(set);
			} else if (log.isDebugEnabled()) {
				log.debug(set + " -> UNKNOWN REPO");
			}
		}
		return null;
	}

}
