package eu.dnetlib.msro.openaireplus.workflows.nodes.objectStore;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.download.plugin.PathRetreiver;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.download.DownloadFromMetadata;

public class DownloadFromMetadataOpenaire extends DownloadFromMetadata {

	private String basepath;

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		if ((this.getBasepath() != null) && (this.getBasepath().length() > 0)) {
			if ("europePMCDownloadPlugin".equals(this.getPlugin())) {
				PathRetreiver.getInstance(this.getBasepath());
			}
		}
		super.prepareJob(job, token);
	}

	/**
	 * @return the basepath
	 */
	public String getBasepath() {
		return basepath;
	}

	/**
	 * @param basepath
	 *            the basepath to set
	 */
	public void setBasepath(final String basepath) {
		this.basepath = basepath;
	}

}
