package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import org.apache.commons.lang.StringUtils;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;

/**
 * SwitchIndexJobNode performs index switch.
 * 
 * @author claudio
 * 
 */
public class SwitchIndexJobNode extends BlackboardJobNode {

	private static final String BB_ACTION_SWITCH_INDEX = "UpdateIndex";

	private String inputIndexIdParam;

	private String outputIndexIdParam;

	private String xqueryForServiceIdParam;

	@Override
	protected String getXqueryForServiceId(final NodeToken token) {
		return token.getEnv().getAttribute(getXqueryForServiceIdParam());
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction(BB_ACTION_SWITCH_INDEX);
		String indexId = token.getEnv().getAttribute(getInputIndexIdParam());

		checkParam(getInputIndexIdParam(), "output indexId param is missing");
		checkParam(indexId, "indexId is required to perform switch");

		job.getParameters().put(getOutputIndexIdParam(), indexId);
	}

	private void checkParam(final String param, final String msg) throws MSROException {
		if (StringUtils.isBlank(param)) throw new MSROException(msg);
	}

	public String getInputIndexIdParam() {
		return inputIndexIdParam;
	}

	public void setInputIndexIdParam(final String inputIndexIdParam) {
		this.inputIndexIdParam = inputIndexIdParam;
	}

	public String getOutputIndexIdParam() {
		return outputIndexIdParam;
	}

	public void setOutputIndexIdParam(final String outputIndexIdParam) {
		this.outputIndexIdParam = outputIndexIdParam;
	}

	public String getXqueryForServiceIdParam() {
		return xqueryForServiceIdParam;
	}

	public void setXqueryForServiceIdParam(final String xqueryForServiceIdParam) {
		this.xqueryForServiceIdParam = xqueryForServiceIdParam;
	}

}
