package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.hadoop.rmi.HadoopBlackboardActions;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;

public class DeleteHdfsPathJobNode extends BlackboardJobNode {

	private String cluster;

	@Override
	protected String getXqueryForServiceId(NodeToken token) {
		return "collection('/db/DRIVER/ServiceResources/HadoopServiceResourceType')//RESOURCE_IDENTIFIER/@value/string()";
	}

	@Override
	protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {

		job.setAction(HadoopBlackboardActions.DELETE_HDFS_PATH.toString());
		job.getParameters().put("cluster", getCluster());

		// The "path" parameter is set by the following call
		job.getParameters().putAll(parseJsonParameters(token));
	}

	public String getCluster() {
		return cluster;
	}

	public void setCluster(String cluster) {
		this.cluster = cluster;
	}

}
