package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.hadoop.rmi.HadoopService;

public class ExistHBaseTableJobNode extends AbstractHBaseAdminJobNode {

	private static final Log log = LogFactory.getLog(ExistHBaseTableJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String existOutNode;

	private String dontExistOutNode;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String tableName = tableName(token);
		final String cluster = cluster(token);

		log.info("checking table existance: '" + tableName + "' on cluster: '" + cluster + "'");

		boolean exists = getServiceLocator().getService(HadoopService.class).existHbaseTable(cluster, tableName);

		log.info("table '" + tableName + "' exists: " + exists);

		return exists ? getExistOutNode() : getDontExistOutNode();
	}

	public String getExistOutNode() {
		return existOutNode;
	}

	public void setExistOutNode(final String existOutNode) {
		this.existOutNode = existOutNode;
	}

	public String getDontExistOutNode() {
		return dontExistOutNode;
	}

	public void setDontExistOutNode(final String dontExistOutNode) {
		this.dontExistOutNode = dontExistOutNode;
	}

}
