package eu.dnetlib.msro.openaireplus.workflows.nodes.download;

import java.io.ByteArrayInputStream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

import com.google.common.base.Function;

public class URLGenerator implements Function<String, String> {

	final private String dcNamespace = "http://purl.org/dc/elements/1.1/";

	final private XMLInputFactory factory = XMLInputFactory.newInstance();

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.google.common.base.Function#apply(java.lang.Object)
	 */
	@Override
	public String apply(final String input) {

		try {
			LinkedObject object = new LinkedObject();
			XMLStreamReader parser = factory.createXMLStreamReader(new ByteArrayInputStream(input.getBytes()));

			while (parser.hasNext()) {
				int event = parser.next();
				if (event == XMLStreamConstants.START_ELEMENT) {
					String name = parser.getLocalName();
					if ("identifier".equals(name)) {
						String namespace = parser.getName().getNamespaceURI();
						if (namespace != null) {
							namespace = namespace.trim();
						}
						if (dcNamespace.equals(namespace)) {
							parser.next();
							object.addURL(parser.getText().trim());
						}
					} else if ("objIdentifier".equals(name)) {
						parser.next();
						object.setObjectIdentifier(parser.getText().trim());
					}
				}
			}
			return object.toJSON();
		} catch (XMLStreamException e) {
			return null;
		}
	}

}
