package eu.dnetlib.msro.openaireplus.workflows.nodes.download;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import com.google.common.collect.Iterables;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class RetrieveURLJobNode extends SimpleJobNode {

	private String inputEprParam;
	private String outputEprParam;

	private ResultSetClientFactory resultSetClientFactory;

	@Resource(name = "iterableResultSetFactory")
	private IterableResultSetFactory resultSetFactory;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final W3CEndpointReference inputEpr = (new EPRUtils()).getEpr(token.getEnv().getAttribute(inputEprParam));
		Iterable<String> input = resultSetClientFactory.getClient(inputEpr);
		Iterable<String> extractedUrls = Iterables.transform(input, new URLGenerator());
		W3CEndpointReference eprUrls = resultSetFactory.createIterableResultSet(extractedUrls);
		token.getEnv().setAttribute(outputEprParam, eprUrls.toString());
		return Arc.DEFAULT_ARC;
	}

	// SETTTER AND GETTER SECTION
	public String getInputEprParam() {
		return inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public ResultSetClientFactory getResultSetClientFactory() {
		return resultSetClientFactory;
	}

	public void setResultSetClientFactory(final ResultSetClientFactory resultSetClientFactory) {
		this.resultSetClientFactory = resultSetClientFactory;
	}

	public IterableResultSetFactory getResultSetFactory() {
		return resultSetFactory;
	}

	public void setResultSetFactory(final IterableResultSetFactory resultSetFactory) {
		this.resultSetFactory = resultSetFactory;
	}

}
