package eu.dnetlib.msro.openaireplus.workflows.nodes.actions;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;

public class PromoteActionsJobNode extends BlackboardJobNode {

	public static final String ALL_SETS = "ALL SETS";

	private String set;

	@Override
	protected String getXqueryForServiceId(final NodeToken token) {
		return "//RESOURCE_IDENTIFIER[../RESOURCE_TYPE/@value='ActionManagerServiceResourceType']/@value/string()";
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction("PROMOTE");
		if (set != null && !set.isEmpty() && !set.equals(ALL_SETS)) {
			job.getParameters().put("set", set);
		}
	}

	public String getSet() {
		return set;
	}

	public void setSet(final String set) {
		this.set = set;
	}

}
