package eu.dnetlib.msro.openaireplus.workflows.nodes.actions;

import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.actionmanager.set.RawSet;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class PrepareActionSetsJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(PrepareActionSetsJobNode.class);

	private String sets;

	@Override
	protected String execute(NodeToken token) throws Exception {

		final List<Map<String, String>> setList = getSetList();
		final String now = DateUtils.now_ISO8601();

		for (Map<String, String> set : setList) {
			set.put("rawset", RawSet.newInstance().getId());
			set.put("creationDate", now);

			log.info("preparing set: " + set.toString());

			// setting the job properties needed to name the rawsets
			token.getEnv().setAttribute(set.get("jobProperty"), set.get("rawset"));
		}

		token.getEnv().setAttribute("sets", new Gson().toJson(setList));

		return Arc.DEFAULT_ARC;
	}

	@SuppressWarnings("unchecked")
	protected List<Map<String, String>> getSetList() {
		return new Gson().fromJson(getSets(), List.class);
	}

	public String getSets() {
		return sets;
	}

	public void setSets(String sets) {
		this.sets = sets;
	}

}
