package eu.dnetlib.msro.openaireplus.workflows.nodes;

import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

public class PrepareIISMainParamsJobNode extends PrepareIISParams {

	private String xqueryObjectStores;

	private String objectStoreParam = "import_content_objectstores_csv";

	// Enable/Disable inference modules

	private boolean metadataextractionEnabled;

	private String metadataextractionParam = "active_metadataextraction_export";

	private boolean citationmatchingEnabled;

	private String citationMatchingParam = "active_citationmatching";

	private boolean documentsclassificationEnabled;

	private String documentsclassificationParam = "active_documentsclassification";

	private boolean documentssimilarityEnabled;

	private String documentsimilarityParam = "active_documentssimilarity";

	private boolean referenceextractionDatasetEnabled;

	private String referenceextractionDatasetParam = "active_referenceextraction_dataset";

	private boolean referenceextractionProjectEnabled;

	private String referenceextractionProjectParam = "active_referenceextraction_project";

	private boolean referenceextractionResearchinitiativeEnabled;

	private String referenceextractionResearchinitiativeParam = "active_referenceextraction_researchinitiative";

	private boolean statisticsEnabled;

	private String statisticsParam = "active_statistics";

	@Override
	protected String execute(final NodeToken token) throws Exception {

		super.prepare(token);

		token.getEnv().setAttribute(getObjectStoreParam(), getFilteredObjectStoreCSV(getXqueryObjectStores()));

		token.getEnv().setAttribute(getMetadataextractionParam(), isMetadataextractionEnabled());
		token.getEnv().setAttribute(getCitationMatchingParam(), isCitationmatchingEnabled());
		token.getEnv().setAttribute(getDocumentsclassificationParam(), isDocumentsclassificationEnabled());
		token.getEnv().setAttribute(getDocumentsimilarityParam(), isDocumentssimilarityEnabled());
		token.getEnv().setAttribute(getReferenceextractionDatasetParam(), isReferenceextractionDatasetEnabled());
		token.getEnv().setAttribute(getReferenceextractionProjectParam(), isReferenceextractionProjectEnabled());
		token.getEnv().setAttribute(getReferenceextractionResearchinitiativeParam(), isReferenceextractionResearchinitiativeEnabled());
		token.getEnv().setAttribute(getStatisticsParam(), isStatisticsEnabled());

		return Arc.DEFAULT_ARC;
	}

	public String getXqueryObjectStores() {
		return xqueryObjectStores;
	}

	@Required
	public void setXqueryObjectStores(final String xqueryObjectStores) {
		this.xqueryObjectStores = xqueryObjectStores;
	}

	public String getObjectStoreParam() {
		return objectStoreParam;
	}

	public void setObjectStoreParam(final String objectStoreParam) {
		this.objectStoreParam = objectStoreParam;
	}

	public String getMetadataextractionParam() {
		return metadataextractionParam;
	}

	public void setMetadataextractionParam(final String metadataextractionParam) {
		this.metadataextractionParam = metadataextractionParam;
	}

	public boolean isCitationmatchingEnabled() {
		return citationmatchingEnabled;
	}

	public void setCitationmatchingEnabled(final boolean citationmatchingEnabled) {
		this.citationmatchingEnabled = citationmatchingEnabled;
	}

	public String getCitationMatchingParam() {
		return citationMatchingParam;
	}

	public void setCitationMatchingParam(final String citationMatchingParam) {
		this.citationMatchingParam = citationMatchingParam;
	}

	public boolean isDocumentsclassificationEnabled() {
		return documentsclassificationEnabled;
	}

	public void setDocumentsclassificationEnabled(final boolean documentsclassificationEnabled) {
		this.documentsclassificationEnabled = documentsclassificationEnabled;
	}

	public String getDocumentsclassificationParam() {
		return documentsclassificationParam;
	}

	public void setDocumentsclassificationParam(final String documentsclassificationParam) {
		this.documentsclassificationParam = documentsclassificationParam;
	}

	public boolean isDocumentssimilarityEnabled() {
		return documentssimilarityEnabled;
	}

	public void setDocumentssimilarityEnabled(final boolean documentssimilarityEnabled) {
		this.documentssimilarityEnabled = documentssimilarityEnabled;
	}

	public String getDocumentsimilarityParam() {
		return documentsimilarityParam;
	}

	public void setDocumentsimilarityParam(final String documentsimilarityParam) {
		this.documentsimilarityParam = documentsimilarityParam;
	}

	public boolean isReferenceextractionDatasetEnabled() {
		return referenceextractionDatasetEnabled;
	}

	public void setReferenceextractionDatasetEnabled(final boolean referenceextractionDatasetEnabled) {
		this.referenceextractionDatasetEnabled = referenceextractionDatasetEnabled;
	}

	public String getReferenceextractionDatasetParam() {
		return referenceextractionDatasetParam;
	}

	public void setReferenceextractionDatasetParam(final String referenceextractionDatasetParam) {
		this.referenceextractionDatasetParam = referenceextractionDatasetParam;
	}

	public boolean isReferenceextractionProjectEnabled() {
		return referenceextractionProjectEnabled;
	}

	public void setReferenceextractionProjectEnabled(final boolean referenceextractionProjectEnabled) {
		this.referenceextractionProjectEnabled = referenceextractionProjectEnabled;
	}

	public String getReferenceextractionProjectParam() {
		return referenceextractionProjectParam;
	}

	public void setReferenceextractionProjectParam(final String referenceextractionProjectParam) {
		this.referenceextractionProjectParam = referenceextractionProjectParam;
	}

	public boolean isReferenceextractionResearchinitiativeEnabled() {
		return referenceextractionResearchinitiativeEnabled;
	}

	public void setReferenceextractionResearchinitiativeEnabled(final boolean referenceextractionResearchinitiativeEnabled) {
		this.referenceextractionResearchinitiativeEnabled = referenceextractionResearchinitiativeEnabled;
	}

	public String getReferenceextractionResearchinitiativeParam() {
		return referenceextractionResearchinitiativeParam;
	}

	public void setReferenceextractionResearchinitiativeParam(final String referenceextractionResearchinitiativeParam) {
		this.referenceextractionResearchinitiativeParam = referenceextractionResearchinitiativeParam;
	}

	public boolean isStatisticsEnabled() {
		return statisticsEnabled;
	}

	public void setStatisticsEnabled(final boolean statisticsEnabled) {
		this.statisticsEnabled = statisticsEnabled;
	}

	public String getStatisticsParam() {
		return statisticsParam;
	}

	public void setStatisticsParam(final String statisticsParam) {
		this.statisticsParam = statisticsParam;
	}

	public boolean isMetadataextractionEnabled() {
		return metadataextractionEnabled;
	}

	public void setMetadataextractionEnabled(final boolean metadataextractionEnabled) {
		this.metadataextractionEnabled = metadataextractionEnabled;
	}

}
