<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:oai="http://www.openarchives.org/OAI/2.0/"
                xmlns:datetime="http://exslt.org/dates-and-times" xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:md="http://www.pangaea.de/MetaData" xmlns:oaa="http://namespace.openaire.eu/oaa"
                xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:fn="http://www.w3.org/2005/xpath-functions"
                xmlns:dnet="eu.dnetlib.data.transform.xml.DNetMdStoreToHbaseXsltFunctions"
                xmlns:stringUtils="org.apache.commons.lang.StringUtils"
                exclude-result-prefixes="xsl dnet oaa fn stringUtils datetime">

    <xsl:param name="namespacePrefix" />
    <xsl:param name="dataprovider_id" />
    <xsl:param name="parentDatasourceId" />
    <xsl:param name="dataprovider_name" />

    <xsl:template match="/">
        <xsl:variable name="identifier">
            <xsl:value-of
                    select="stringUtils:substringAfter(//md:citation/md:URI,'doi:')" />
        </xsl:variable>
        <xsl:variable name="identifier_datacite">
            <xsl:value-of select="oai:record/oai:header/dri:objIdentifier" />
        </xsl:variable>
        <publications>
            <xsl:for-each select="//md:reference[./@relationTypeId='12']">
                <xsl:variable name="pub_identifier">
                    <xsl:value-of select="./@id" />
                </xsl:variable>
                <publication>
                    <oai:record>
                        <oai:header>
                            <dri:objIdentifier>
                                <xsl:value-of
                                        select="concat($namespacePrefix,'::', dnet:md5($pub_identifier))" />
                            </dri:objIdentifier>
                            <dri:recordIdentifier>
                                <xsl:value-of select="$pub_identifier" />
                            </dri:recordIdentifier>
                            <dri:dateOfCollection>
                                <xsl:value-of select="datetime:dateTime()" />
                            </dri:dateOfCollection>
                            <dri:repositoryId>
                                <xsl:value-of select="$dataprovider_id" />
                            </dri:repositoryId>
                            <oaf:datasourceprefix>
                                <xsl:value-of select="$namespacePrefix" />
                            </oaf:datasourceprefix>
                        </oai:header>
                        <oai:metadata>
                            <dc:identifier>
                                <xsl:value-of select="$pub_identifier" />
                            </dc:identifier>
                            <dc:title>
                                <xsl:value-of select=".//md:title" />
                            </dc:title>
                            <xsl:for-each select=".//md:author">
                                <dc:creator>
                                    <xsl:value-of select="concat(./md:lastName,' ', md:firstName)" />
                                </dc:creator>
                            </xsl:for-each>
                            <dc:source>
                                <xsl:value-of select="./md:source" />
                            </dc:source>
                            <dr:CobjCategory>0000</dr:CobjCategory>
                            <dc:language>und</dc:language>
                            <oaf:journal>
                                <xsl:value-of select="./md:source" />
                            </oaf:journal>
                            <oaf:accessrights>UNKNOWN</oaf:accessrights>
                            <oaf:projectid>
                                <xsl:value-of select="//oaf:projectid" />
                            </oaf:projectid>
                            <oaf:hostedBy
                                    id="openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18" name="Unknown Repository" />
                            <oaf:collectedFrom>
                                <xsl:attribute name="id">
                                    <xsl:value-of
                                            select="$parentDatasourceId" />
                                </xsl:attribute>
                                <xsl:attribute name="name">
                                    <xsl:value-of
                                            select="$dataprovider_name" />
                                </xsl:attribute>
                            </oaf:collectedFrom>
                            <oaf:relatedDataset>
                                <xsl:attribute name="id"><xsl:value-of
                                        select="$identifier_datacite" /></xsl:attribute>
                            </oaf:relatedDataset>
                        </oai:metadata>
                    </oai:record>
                </publication>
            </xsl:for-each>

        </publications>
    </xsl:template>
</xsl:stylesheet>