<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:oai="http://www.openarchives.org/OAI/2.0/"
	xmlns:datetime="http://exslt.org/dates-and-times" xmlns:dri="http://www.driver-repository.eu/namespace/dri"
	xmlns:md="http://www.pangaea.de/MetaData" xmlns:oaa="http://namespace.openaire.eu/oaa"
	xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:dnet="eu.dnetlib.data.transform.xml.DNetMdStoreToHbaseXsltFunctions"
	xmlns:stringUtils="org.apache.commons.lang.StringUtils"
	exclude-result-prefixes="xsl dnet oaa fn stringUtils datetime">

	<xsl:param name="namespacePrefix" />
	<xsl:param name="dataSourceId" />
	<xsl:param name="parentDatasourceId" />
	<xsl:param name="dataprovider_name" />
	<xsl:param name="dataprovider_id" />

	<xsl:template match="/">
		<xsl:variable name="identifier">
			<xsl:value-of
				select="stringUtils:substringAfter(//md:citation/md:URI,'doi:')" />
		</xsl:variable>

		<xsl:variable name="identifier_datacite">
			<xsl:value-of select="oai:record/oai:header/dri:objIdentifier" />
		</xsl:variable>

		<xsl:variable name="dataset_identifier">
			<xsl:value-of
				select="stringUtils:substringAfter(//md:citation/md:URI,'doi:')" />
		</xsl:variable>
		<xsl:variable name="openaire_dataset_identifier">
			<xsl:value-of
				select="concat($namespacePrefix,'::', dnet:md5($dataset_identifier))" />
		</xsl:variable>

		<oai:record>
			<oai:header>
				<dri:objIdentifier>
					<xsl:value-of select="$openaire_dataset_identifier" />
				</dri:objIdentifier>
				<dri:recordIdentifier>
					<xsl:value-of select="$dataset_identifier" />
				</dri:recordIdentifier>
				<dri:dateOfCollection>
					<xsl:value-of select="datetime:dateTime()" />
				</dri:dateOfCollection>
				<dri:repositoryId>
					<xsl:value-of select="$dataprovider_id" />
				</dri:repositoryId>
				<oaf:datasourceprefix>
					<xsl:value-of select="$namespacePrefix" />
				</oaf:datasourceprefix>
			</oai:header>
			<oai:metadata>
				<resource
					xsi:schemaLocation="http://datacite.org/schema/kernel-3 http://schema.datacite.org/meta/kernel-3/metadata.xsd"
					xmlns="http://datacite.org/schema/kernel-3" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
					<identifier identifierType="DOI">
						<xsl:value-of
							select="stringUtils:substringAfter(//md:citation/md:URI,'doi:')" />
					</identifier>
					<creators>
						<xsl:for-each select="//md:citation/md:author">
							<creator>
								<creatorName>
									<xsl:value-of select="concat(./md:firstName, ' ', ./md:lastName)" />
								</creatorName>
								<nameIdentifier schemeURI="http://www.pangaea.de"
									nameIdentifierScheme="PANGAEA">
									<xsl:value-of select="./@id" />
								</nameIdentifier>

							</creator>
						</xsl:for-each>
					</creators>
					<titles>
						<xsl:for-each select="//md:citation/md:title">
							<title xml:lang="en-us">
								<xsl:value-of select="." />
							</title>
						</xsl:for-each>
					</titles>
					<publisher>PANGAEA</publisher>
					<publicationYear>
						<xsl:value-of select="//md:citation/md:year" />
					</publicationYear>
					<xsl:variable name="description">
						<xsl:value-of select="//md:citation/md:abstract" />
					</xsl:variable>
					<xsl:if test="$description">
						<descriptions>
							<description descriptionType="Abstract">
								<xsl:value-of select="$description" />
							</description>
						</descriptions>
					</xsl:if>
					<rights>info:eu-repo/semantics/openAccess</rights>
					<contributors>
						<contributor contributorType="Funder">
							<contributorName>European Commission</contributorName>
							<nameIdentifier nameIdentifierScheme="info"><xsl:value-of select="//oaf:projectid"/></nameIdentifier>
						</contributor>
					</contributors>
				</resource>
			</oai:metadata>
		</oai:record>
	</xsl:template>
</xsl:stylesheet>
