package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

/**
 * This jobNode reads all the metadata records from all the mongodb collections and generates an hdfs sequence file.
 * 
 * @author claudio
 * 
 */
public class MDStoreBatchExporterJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(MDStoreBatchExporterJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String format;

	private String layout;

	private String interpretation;

	private String outputEprParam;
	
	private ServiceLocator<MDStoreService> mdstoreLocator;

	@Override
	public String execute(final NodeToken token) throws Exception {
		log.info("bulk reading MDStores: " + getFormat() + "-" + getLayout() + "-" + getInterpretation());
		W3CEndpointReference epr = getMdstoreLocator().getService().bulkDeliverMDRecords(getFormat(), getLayout(), getInterpretation());
		token.getEnv().setAttribute(getOutputEprParam(), epr.toString());

		return Arc.DEFAULT_ARC;
	}

	public String getFormat() {
		return format;
	}

	public void setFormat(String format) {
		this.format = format;
	}

	public String getLayout() {
		return layout;
	}

	public void setLayout(String layout) {
		this.layout = layout;
	}

	public String getInterpretation() {
		return interpretation;
	}

	public void setInterpretation(String interpretation) {
		this.interpretation = interpretation;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public ServiceLocator<MDStoreService> getMdstoreLocator() {
		return mdstoreLocator;
	}

	@Required
	public void setMdstoreLocator(ServiceLocator<MDStoreService> mdstoreLocator) {
		this.mdstoreLocator = mdstoreLocator;
	}

}
