package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.NodeToken;

public class ExistHBaseTableJobNode extends AbstractHBaseAdminJobNode {

	private static final Log log = LogFactory.getLog(ExistHBaseTableJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String tableName = tableName(token);
		final String cluster = cluster(token);

		log.info("checking table existance: '" + tableName + "' on cluster: '" + cluster + "'");

		boolean exists = hadoopServiceLocator.getService().existHbaseTable(cluster, tableName);

		log.info("table '" + tableName + "' exists: " + exists);

		return exists ? "drop" : "create";
	}

}
