package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.msro.openaireplus.workflows.hbase.HBaseTableUtils;

public class CreateHBaseTableJobNode extends AbstractHBaseAdminJobNode {

	private static final Log log = LogFactory.getLog(CreateHBaseTableJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String xqueryForColumnsProperty;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final Set<String> columns = HBaseTableUtils.listColumns();
		final String tableName = tableName(token);
		final String cluster = cluster(token);

		log.debug("Ensuring table " + tableName + " on cluster: '" + cluster + "' - columns: " + columns);

		hadoopServiceLocator.getService().createHbaseTable(cluster, tableName, columns);

		return Arc.DEFAULT_ARC;
	}

	public String getXqueryForColumnsProperty() {
		return xqueryForColumnsProperty;
	}

	public void setXqueryForColumnsProperty(final String xqueryForColumnsProperty) {
		this.xqueryForColumnsProperty = xqueryForColumnsProperty;
	}

}
