package eu.dnetlib.msro.openaireplus.workflows.nodes.download;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;

public class LinkedObject {

	public static LinkedObject createFromJSON(final String json) {
		if (json != null) {
			Gson g = new Gson();
			return g.fromJson(json, LinkedObject.class);
		}
		return null;
	}

	private String objectIdentifier;

	private List<String> URLS;

	public void addURL(final String URL) {
		if (URLS == null) {
			URLS = new ArrayList<String>();
		}
		URLS.add(URL);
	}

	public String toJSON() {
		Gson g = new Gson();
		return g.toJson(this).replace("\\u003d", "=").replace("\\u0026", "&");
	}

	public String getObjectIdentifier() {
		return objectIdentifier;
	}

	public void setObjectIdentifier(final String objectIdentifier) {
		this.objectIdentifier = objectIdentifier;
	}

	public List<String> getURLS() {
		return URLS;
	}

	public void setURLS(final List<String> uRLS) {
		URLS = uRLS;
	}
}
