package eu.dnetlib.msro.openaireplus.workflows.nodes.datacite;

import java.util.Map.Entry;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.datasources.rmi.DatasourceDesc;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException;
import eu.dnetlib.enabling.datasources.rmi.IfaceDesc;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class ValidateDataciteHostedByReposJobNode extends SimpleJobNode {
	private static final Log log = LogFactory.getLog(ValidateDataciteHostedByReposJobNode.class);
	
	private static final String HOSTED_BY_COMPLIANCE = "hostedBy";
	
	private ServiceLocator<DatasourceManagerService> datasourceManagerLocator;

	private String countersParam;	
	private String mdId;
	private String extraFieldsForTotal;
	private String extraFieldForDate;
	private String extraFieldForMdId;

	@Override
	protected String execute(NodeToken token) throws Exception {
		final DataciteHostedByCounters counters = (DataciteHostedByCounters) token.getEnv().getTransientAttribute(countersParam);
		final DatasourceManagerService dsManager = datasourceManagerLocator.getService();
		final String date = DateUtils.now_ISO8601();  
		
		log.info(counters);
		
		for(Entry<String, Integer> e : counters.getCounters().entrySet()) {
			updateHostedByApi(dsManager, e.getKey(), date, e.getValue());
		}
			
		return Arc.DEFAULT_ARC;
	}

	private void updateHostedByApi(final DatasourceManagerService dsManager, final String dsId, final String date, final int size) {
		log.info("Verifying hostedBy api in ds: " + dsId);
		try {
			final DatasourceDesc ds = dsManager.getDatasource(dsId);
				
			for (IfaceDesc iface : ds.getInterfaces()) {
				if (HOSTED_BY_COMPLIANCE.equals(iface.getCompliance())) {
					if (StringUtils.isNotBlank(extraFieldForDate)) {
						dsManager.updateExtraField(dsId, iface.getId(), extraFieldForDate, date, false);
					}
					if (StringUtils.isNotBlank(extraFieldsForTotal)) {
						dsManager.updateExtraField(dsId, iface.getId(), extraFieldsForTotal, Integer.toString(size), false);
					}
					if (StringUtils.isNotBlank(mdId) && StringUtils.isNotBlank(extraFieldForMdId)) {
						dsManager.updateExtraField(dsId, iface.getId(), extraFieldForMdId, mdId, false);
					}
					return;
				}
			}
							
			final IfaceDesc iface = new IfaceDesc();
			iface.setId("api_________::" + dsId + "::hostedBy");
			iface.setTypology(ds.getTypology());
			iface.setCompliance(HOSTED_BY_COMPLIANCE);
			iface.setAccessProtocol("UNKNOWN");
			iface.setContentDescription("metadata");
			iface.setBaseUrl("");
			iface.setActive(false);
			iface.setRemovable(true);
			if (StringUtils.isNotBlank(extraFieldForDate)) {
				iface.getExtraFields().put(extraFieldForDate, date);
			}
			if (StringUtils.isNotBlank(extraFieldsForTotal)) {
				iface.getExtraFields().put(extraFieldsForTotal, Integer.toString(size));
			}
			if (StringUtils.isNotBlank(mdId) && StringUtils.isNotBlank(extraFieldForMdId)) {
				iface.getExtraFields().put(extraFieldForMdId, mdId);
			}
			dsManager.addInterface(dsId, iface);
		} catch (DatasourceManagerServiceException e) {
			log.warn("Error setting hostedBy api of ds: " + dsId, e);
		}
	}

	public ServiceLocator<DatasourceManagerService> getDatasourceManagerLocator() {
		return datasourceManagerLocator;
	}
	
	@Required
	public void setDatasourceManagerLocator(ServiceLocator<DatasourceManagerService> datasourceManagerLocator) {
		this.datasourceManagerLocator = datasourceManagerLocator;
	}

	public String getMdId() {
		return mdId;
	}

	public void setMdId(String mdId) {
		this.mdId = mdId;
	}

	public String getExtraFieldsForTotal() {
		return extraFieldsForTotal;
	}

	public void setExtraFieldsForTotal(String extraFieldsForTotal) {
		this.extraFieldsForTotal = extraFieldsForTotal;
	}

	public String getExtraFieldForDate() {
		return extraFieldForDate;
	}

	public void setExtraFieldForDate(String extraFieldForDate) {
		this.extraFieldForDate = extraFieldForDate;
	}

	public String getExtraFieldForMdId() {
		return extraFieldForMdId;
	}

	public void setExtraFieldForMdId(String extraFieldForMdId) {
		this.extraFieldForMdId = extraFieldForMdId;
	}

	public String getCountersParam() {
		return countersParam;
	}

	public void setCountersParam(String countersParam) {
		this.countersParam = countersParam;
	}

}
