package eu.dnetlib.msro.openaireplus.workflows.nodes.datacite;

import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IteratorOnQueue implements Iterator<String> {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(IteratorOnQueue.class);
	private final LinkedBlockingQueue<String> inputQueue;
	private String currentItem;

	public IteratorOnQueue(final LinkedBlockingQueue<String> inputQueue) {
		this.inputQueue = inputQueue;
		try {
			currentItem = this.inputQueue.take();
		} catch (InterruptedException e) {
			log.error(e);
		}
	}

	@Override
	public boolean hasNext() {

		return (currentItem != SplitterDatasetsIterator.END_QUEUE);
	}

	@Override
	public String next() {

		String previous = currentItem;
		try {
			currentItem = this.inputQueue.take();
		} catch (Exception e) {
			log.error(e);
		}
		return previous;
	}

	@Override
	public void remove() {
		// TODO Auto-generated method stub

	}

}
