package eu.dnetlib.msro.openaireplus.workflows.nodes.datacite;

import java.io.StringReader;
import java.util.Map;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class DataciteHostedByJobNode extends SimpleJobNode {
	
	private String inputEprParam;
	private String outputEprParam;
	private String dbName;
	private String countersParam;
	
	private ServiceLocator<DatabaseService> dbServiceLocator;

	private MappedResultSetFactory mappedResultSetFactory;
	
	private ResultSetClientFactory resultSetClientFactory;
	
	private static final Log log = LogFactory.getLog(DataciteHostedByJobNode.class);
	
	@Override
	protected String execute(final NodeToken token) throws Exception {
		final W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(inputEprParam));
		final DataciteHostedByCounters counters = new DataciteHostedByCounters();
		
		final W3CEndpointReference epr = mappedResultSetFactory.createMappedResultSet(inputEpr, new PatchHostedBy(loadHostedByMap(), counters));
		
		token.getEnv().setAttribute(outputEprParam, epr.toString());
		token.getEnv().setTransientAttribute(countersParam, counters);
		
		return Arc.DEFAULT_ARC;
	}


	private Map<String, HostedByEntry> loadHostedByMap() {
		final Map<String, HostedByEntry> map = Maps.newHashMap();
				
		try {
			final String sql = "SELECT setspec, datasourceid, datasourcename FROM datacite_sets WHERE datasourceid IS NOT NULL";
	
			final W3CEndpointReference epr = dbServiceLocator.getService().searchSQL(getDbName(), sql);
			
			final SAXReader reader = new SAXReader();
			for (String s : resultSetClientFactory.getClient(epr)) {
				final Document doc = reader.read(new StringReader(s));
				final String set = doc.valueOf("//FIELD[@name='setspec']");
				final String dsId = doc.valueOf("//FIELD[@name='datasourceid']");
				final String dsName = doc.valueOf("//FIELD[@name='datasourcename']");
				map.put(set, new HostedByEntry(dsId, dsName));
			}
		} catch(Throwable e) {
			log.error("Error calculating set->hostedBy map, ", e);
		}
		return map;
	}


	public String getInputEprParam() {
		return inputEprParam;
	}


	public void setInputEprParam(String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}


	public String getOutputEprParam() {
		return outputEprParam;
	}


	public void setOutputEprParam(String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public String getDbName() {
		return dbName;
	}


	public void setDbName(String dbName) {
		this.dbName = dbName;
	}
	
	public ServiceLocator<DatabaseService> getDbServiceLocator() {
		return dbServiceLocator;
	}

	@Required
	public void setDbServiceLocator(ServiceLocator<DatabaseService> dbServiceLocator) {
		this.dbServiceLocator = dbServiceLocator;
	}


	public MappedResultSetFactory getMappedResultSetFactory() {
		return mappedResultSetFactory;
	}

	@Required
	public void setMappedResultSetFactory(MappedResultSetFactory mappedResultSetFactory) {
		this.mappedResultSetFactory = mappedResultSetFactory;
	}


	public ResultSetClientFactory getResultSetClientFactory() {
		return resultSetClientFactory;
	}

	@Required
	public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
		this.resultSetClientFactory = resultSetClientFactory;
	}


	public String getCountersParam() {
		return countersParam;
	}


	public void setCountersParam(String countersParam) {
		this.countersParam = countersParam;
	}
}
