package eu.dnetlib.msro.openaireplus.workflows.nodes.actions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class CleanActionSetsProfileJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(CleanActionSetsProfileJobNode.class);

	@Autowired
	private ServiceLocator<ISRegistryService> registryLocator;

	private String xupdate;

	@Override
	protected String execute(NodeToken token) throws Exception {
		log.info("updating Action Sets profiles: " + getXupdate());
		registryLocator.getService().executeXUpdate(getXupdate());
		return Arc.DEFAULT_ARC;
	}

	public String getXupdate() {
		return xupdate;
	}

	@Required
	public void setXupdate(String xupdate) {
		this.xupdate = xupdate;
	}

}
