package eu.dnetlib.msro.openaireplus.workflows.nodes;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class FindVocabularyEntriesJobNode extends SimpleJobNode {

	private String outputEprParam = "epr";

	private ServiceLocator<ISLookUpService> lookupLocator;

	private Resource xquery;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String query = IOUtils.toString(xquery.getInputStream());
		final W3CEndpointReference epr = lookupLocator.getService().searchProfile(query);
		token.getEnv().setAttribute(getOutputEprParam(), epr.toString());

		return Arc.DEFAULT_ARC;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return lookupLocator;
	}

	@Required
	public void setLookupLocator(final ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}

	public Resource getXquery() {
		return xquery;
	}

	@Required
	public void setXquery(final Resource xquery) {
		this.xquery = xquery;
	}

}
