<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:dr="http://www.driver-repository.eu/namespace/dr"
    xmlns:dri="http://www.driver-repository.eu/namespace/dri"
    xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
    xmlns:fn="http://www.w3.org/2005/xpath-functions"
    xmlns:dnet="eu.dnetlib.data.transform.xml.DNetMdStoreToHbaseXsltFunctions"
    xmlns:stringUtils="org.apache.commons.lang.StringUtils">

    <xsl:param name="parentDatasourceId"/>
    <xsl:param name="namespacePrefix"/>

    <xsl:template match="/">
        <record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
            xmlns:dri="http://www.driver-repository.eu/namespace/dri"
            xmlns:dc="http://purl.org/dc/elements/1.1/"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns:oaf="http://namespace.openaire.eu/oaf"
            xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">

            <xsl:copy-of select=".//*[local-name()='header']"/>
            <metadata>
                <xsl:variable name="rid" select="normalize-space(//column[./@name='ISSN'])"/>
                <xsl:variable name="datasourceId" select="concat($namespacePrefix, '::', $rid)"/>
                <xsl:variable name="ISSNNS" select="stringUtils:replace($rid,'-','')"/>
                <xsl:variable name="oName" select="normalize-space(//column[./@name='Title'])"/>
                <xsl:variable name="organizationId"
                    select="translate(concat($namespacePrefix, '::', $oName), ' ', '_')"/>               
                <ROWS>
                    <ROW table="datasources">
                        <FIELD name="id">
                            <xsl:value-of select="$datasourceId"/>
                        </FIELD>
                        <FIELD name="_dnet_resource_identifier_">
                            <xsl:value-of select="$datasourceId"/>
                        </FIELD>
                        <FIELD name="officialname">
                            <xsl:value-of select="normalize-space(//column[./@name='Title'])"/>
                        </FIELD>
                        <FIELD name="englishname">
                            <xsl:value-of select="normalize-space(//column[./@name='Title'])"/>
                        </FIELD>
                        <FIELD name="od_contenttypes">
                            <xsl:value-of select="string('Journal articles')"/>
                        </FIELD>
                        <FIELD name="od_languages">
                            <xsl:value-of select="normalize-space(//column[./@name='Language'])"/>
                        </FIELD>
                        <FIELD name="issn">
                            <xsl:value-of select="normalize-space(//column[./@name='ISSN'])"/>
                        </FIELD>
                        <FIELD name="eissn">
                            <xsl:value-of select="normalize-space(//column[./@name='EISSN'])"/>
                        </FIELD>
                        <FIELD name="description">
                            <xsl:value-of select="normalize-space(//column[./@name='Keyword'])"/>
                        </FIELD>                      
                        <FIELD name="websiteurl">
                            <xsl:value-of select="normalize-space(//column[./@name='Identifier'])"/>
                        </FIELD>                       
                        <FIELD name="namespaceprefix">
                            <xsl:value-of select="concat('doaj', $ISSNNS)"/>
                        </FIELD>
                        <FIELD name="datasourceclass">pubsrepository::journal</FIELD>
                        <FIELD name="datasourcescheme">dnet:datasource_typologies</FIELD>
                        <FIELD name="collectedfrom">
                            <xsl:value-of select="$parentDatasourceId"/>
                        </FIELD>
                    </ROW>

                    <xsl:variable name="apiId"
                        select="concat('api_________::', $datasourceId, '::0')"/>
                    <ROW table="api">
                        <FIELD name="id">
                            <xsl:value-of select="$apiId"/>
                        </FIELD>
                        <FIELD name="_dnet_resource_identifier_">
                            <xsl:value-of select="$apiId"/>
                        </FIELD>
                        <FIELD name="protocolclass">filesystem</FIELD>
                        <FIELD name="datasource">
                            <xsl:value-of select="$datasourceId"/>
                        </FIELD>
                        <FIELD name="contentdescriptionclass">metadata</FIELD>
                        <FIELD name="typologyclass">pubsrepository::journal</FIELD>
                        <FIELD name="compatibilityclass">UNKNOWN</FIELD>
                        
                    </ROW>

                    <ROW table="apicollections">
                        <FIELD name="api">
                            <xsl:value-of select="$apiId"/>
                        </FIELD>
                        <FIELD name="param">baseUrl</FIELD>
                        <FIELD name="_dnet_resource_identifier_">
                            <xsl:value-of select="concat($apiId, '@@baseUrl')"/>
                        </FIELD>
                        <xsl:if test="string-length(normalize-space('/dev/null')) &gt; 0">
                            <FIELD name="original">
                                <xsl:value-of select="normalize-space('/dev/null')"/>
                            </FIELD>
                        </xsl:if>
                    </ROW>


                    <ROW table="apicollections">
                        <FIELD name="api">
                            <xsl:value-of select="$apiId"/>
                        </FIELD>
                        <FIELD name="param">metadata_identifier_path</FIELD>
                        <FIELD name="_dnet_resource_identifier_">
                            <xsl:value-of select="concat($apiId, '@@metadata_identifier_path')"/>
                        </FIELD>
                        <FIELD name="original"
                            >//*[local-name()='header']/*[local-name()='identifier']</FIELD>
                        <FIELD name="accessparam" type="boolean">false</FIELD>
                    </ROW>



                </ROWS>
            </metadata>
        </record>
    </xsl:template>

</xsl:stylesheet>
