/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.objectStore;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.openaireplus.workflows.nodes.objectStore.ArxivIteratorRepository;
import eu.dnetlib.msro.openaireplus.workflows.nodes.objectStore.IteratorRepository;
import eu.dnetlib.msro.openaireplus.workflows.nodes.objectStore.PUMAIteratorRepository;
import eu.dnetlib.msro.openaireplus.workflows.nodes.objectStore.RepositoryNoURLIterator;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import java.io.File;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class ImportFilesJobNode
extends BlackboardJobNode
implements ProgressJobNode {
    private String basePath;
    private String repositoryPrefix;
    private String oaiPrefix;
    private String objectStoreId;
    private String contentDescription;
    private ResultsetProgressProvider progressProvider;
    private ProcessCountingResultSetFactory processCountingResultSetFactory;
    private IterableResultSetFactory iterableResultSetFactory;

    public String getRepositoryPrefix() {
        return this.repositoryPrefix;
    }

    public void setRepositoryPrefix(String repositoryPrefix) {
        this.repositoryPrefix = repositoryPrefix;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }

    protected String getXqueryForServiceId(NodeToken token) {
        return "//RESOURCE_IDENTIFIER[../RESOURCE_TYPE/@value='ObjectStoreServiceResourceType']/@value/string()";
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        File dir = new File(this.basePath);
        System.out.println("Getting all files in " + dir.getCanonicalPath() + " including those in subdirectories");
        List files = (List)FileUtils.listFiles((File)dir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        IteratorRepository irepo = this.repositoryPrefix.equals("od________18") ? new ArxivIteratorRepository(files, this.repositoryPrefix, this.oaiPrefix) : (this.repositoryPrefix.equals("od______2367") ? new PUMAIteratorRepository(files, this.repositoryPrefix, this.oaiPrefix) : new RepositoryNoURLIterator(files, this.repositoryPrefix, this.oaiPrefix));
        W3CEndpointReference epr = this.iterableResultSetFactory.createIterableResultSet((Iterable)irepo);
        this.progressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), epr);
        job.setAction("FEED");
        job.getParameters().put("obsID", this.getObjectStoreId());
        job.getParameters().put("mime", this.getContentDescription());
        job.getParameters().put("protocol", Protocols.File_System.toString());
        job.getParameters().put("epr", this.progressProvider.getEpr().toString());
    }

    public IterableResultSetFactory getIterableResultSetFactory() {
        return this.iterableResultSetFactory;
    }

    public void setIterableResultSetFactory(IterableResultSetFactory iterableResultSetFactory) {
        this.iterableResultSetFactory = iterableResultSetFactory;
    }

    public void setProgressProvider(ResultsetProgressProvider progressProvider) {
        this.progressProvider = progressProvider;
    }

    public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
        return this.processCountingResultSetFactory;
    }

    public void setProcessCountingResultSetFactory(ProcessCountingResultSetFactory processCountingResultSetFactory) {
        this.processCountingResultSetFactory = processCountingResultSetFactory;
    }

    public String getObjectStoreId() {
        return this.objectStoreId;
    }

    public void setObjectStoreId(String objectStoreId) {
        this.objectStoreId = objectStoreId;
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    public void setContentDescription(String contentDescription) {
        this.contentDescription = contentDescription;
    }

    public String getOaiPrefix() {
        return this.oaiPrefix;
    }

    public void setOaiPrefix(String oaiPrefix) {
        this.oaiPrefix = oaiPrefix;
    }
}

