/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractHBaseAdminJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(AbstractHBaseAdminJobNode.class);
    private String hbaseTableProperty;
    private String cluster;
    @Autowired
    protected ServiceLocator<HadoopService> hadoopServiceLocator;

    protected void beforeStart(NodeToken token) {
        for (Map.Entry e : this.parseJsonParameters(token).entrySet()) {
            token.getEnv().setAttribute((String)e.getKey(), (String)e.getValue());
        }
    }

    protected String tableName(NodeToken token) {
        if (token.getEnv().hasAttribute("hbaseTable")) {
            String table = token.getEnv().getAttribute("hbaseTable");
            log.info((Object)("found override value in wfEnv for 'hbaseTable' param: " + table));
            return table;
        }
        return this.getPropertyFetcher().getProperty(this.getHbaseTableProperty());
    }

    protected String cluster(NodeToken token) {
        if (token.getEnv().hasAttribute("cluster")) {
            String cluster = token.getEnv().getAttribute("cluster");
            log.info((Object)("found override value in wfEnv for 'cluster' param: " + cluster));
            return cluster;
        }
        return this.getCluster();
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getHbaseTableProperty() {
        return this.hbaseTableProperty;
    }

    public void setHbaseTableProperty(String hbaseTableProperty) {
        this.hbaseTableProperty = hbaseTableProperty;
    }
}

