/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.download;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.openaireplus.workflows.nodes.download.URLGenerator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public class RetrieveURLJobNode
extends SimpleJobNode {
    private String inputEprParam;
    private String outputEprParam;
    private ResultSetClientFactory resultSetClientFactory;
    @Resource(name="iterableResultSetFactory")
    private IterableResultSetFactory resultSetFactory;

    protected String execute(NodeToken token) throws Exception {
        W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(this.inputEprParam));
        IterableResultSetClient input = this.resultSetClientFactory.getClient(inputEpr);
        Iterable extractedUrls = Iterables.transform((Iterable)input, (Function)new URLGenerator());
        W3CEndpointReference eprUrls = this.resultSetFactory.createIterableResultSet(extractedUrls);
        token.getEnv().setAttribute(this.outputEprParam, eprUrls.toString());
        return Arc.DEFAULT_ARC;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public IterableResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    public void setResultSetFactory(IterableResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }
}

