/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.datacite;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.datasources.rmi.DatasourceDesc;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException;
import eu.dnetlib.enabling.datasources.rmi.IfaceDesc;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.openaireplus.workflows.nodes.datacite.DataciteHostedByCounters;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ValidateDataciteHostedByReposJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(ValidateDataciteHostedByReposJobNode.class);
    private static final String HOSTED_BY_COMPLIANCE = "hostedBy";
    private ServiceLocator<DatasourceManagerService> datasourceManagerLocator;
    private String countersParam;
    private String mdId;
    private String extraFieldsForTotal;
    private String extraFieldForDate;
    private String extraFieldForMdId;

    protected String execute(NodeToken token) throws Exception {
        DataciteHostedByCounters counters = (DataciteHostedByCounters)token.getEnv().getTransientAttribute(this.countersParam);
        DatasourceManagerService dsManager = (DatasourceManagerService)this.datasourceManagerLocator.getService();
        String date = DateUtils.now_ISO8601();
        log.info((Object)counters);
        for (Map.Entry<String, Integer> e : counters.getCounters().entrySet()) {
            this.updateHostedByApi(dsManager, e.getKey(), date, e.getValue());
        }
        return Arc.DEFAULT_ARC;
    }

    private void updateHostedByApi(DatasourceManagerService dsManager, String dsId, String date, int size) {
        log.info((Object)("Verifying hostedBy api in ds: " + dsId));
        try {
            DatasourceDesc ds = dsManager.getDatasource(dsId);
            for (IfaceDesc iface : ds.getInterfaces()) {
                if (!HOSTED_BY_COMPLIANCE.equals(iface.getCompliance())) continue;
                if (StringUtils.isNotBlank((String)this.extraFieldForDate)) {
                    dsManager.updateExtraField(dsId, iface.getId(), this.extraFieldForDate, date, false);
                }
                if (StringUtils.isNotBlank((String)this.extraFieldsForTotal)) {
                    dsManager.updateExtraField(dsId, iface.getId(), this.extraFieldsForTotal, Integer.toString(size), false);
                }
                if (StringUtils.isNotBlank((String)this.mdId) && StringUtils.isNotBlank((String)this.extraFieldForMdId)) {
                    dsManager.updateExtraField(dsId, iface.getId(), this.extraFieldForMdId, this.mdId, false);
                }
                return;
            }
            IfaceDesc iface = new IfaceDesc();
            iface.setId("api_________::" + dsId + "::hostedBy");
            iface.setTypology(ds.getTypology());
            iface.setCompliance(HOSTED_BY_COMPLIANCE);
            iface.setAccessProtocol("UNKNOWN");
            iface.setContentDescription("metadata");
            iface.setBaseUrl("");
            iface.setActive(false);
            iface.setRemovable(true);
            if (StringUtils.isNotBlank((String)this.extraFieldForDate)) {
                iface.getExtraFields().put(this.extraFieldForDate, date);
            }
            if (StringUtils.isNotBlank((String)this.extraFieldsForTotal)) {
                iface.getExtraFields().put(this.extraFieldsForTotal, Integer.toString(size));
            }
            if (StringUtils.isNotBlank((String)this.mdId) && StringUtils.isNotBlank((String)this.extraFieldForMdId)) {
                iface.getExtraFields().put(this.extraFieldForMdId, this.mdId);
            }
            dsManager.addInterface(dsId, iface);
        }
        catch (DatasourceManagerServiceException e) {
            log.warn((Object)("Error setting hostedBy api of ds: " + dsId), (Throwable)e);
        }
    }

    public ServiceLocator<DatasourceManagerService> getDatasourceManagerLocator() {
        return this.datasourceManagerLocator;
    }

    @Required
    public void setDatasourceManagerLocator(ServiceLocator<DatasourceManagerService> datasourceManagerLocator) {
        this.datasourceManagerLocator = datasourceManagerLocator;
    }

    public String getMdId() {
        return this.mdId;
    }

    public void setMdId(String mdId) {
        this.mdId = mdId;
    }

    public String getExtraFieldsForTotal() {
        return this.extraFieldsForTotal;
    }

    public void setExtraFieldsForTotal(String extraFieldsForTotal) {
        this.extraFieldsForTotal = extraFieldsForTotal;
    }

    public String getExtraFieldForDate() {
        return this.extraFieldForDate;
    }

    public void setExtraFieldForDate(String extraFieldForDate) {
        this.extraFieldForDate = extraFieldForDate;
    }

    public String getExtraFieldForMdId() {
        return this.extraFieldForMdId;
    }

    public void setExtraFieldForMdId(String extraFieldForMdId) {
        this.extraFieldForMdId = extraFieldForMdId;
    }

    public String getCountersParam() {
        return this.countersParam;
    }

    public void setCountersParam(String countersParam) {
        this.countersParam = countersParam;
    }
}

