/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.actions;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.actionmanager.set.RawSet;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrepareActionSetsJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareActionSetsJobNode.class);
    private String sets;

    protected String execute(NodeToken token) throws Exception {
        List<Map<String, String>> setList = this.getSetList();
        String now = DateUtils.now_ISO8601();
        for (Map<String, String> set : setList) {
            set.put("rawset", RawSet.newInstance().getId());
            set.put("creationDate", now);
            log.info((Object)("preparing set: " + set.toString()));
            token.getEnv().setAttribute(set.get("jobProperty"), set.get("rawset"));
        }
        token.getEnv().setAttribute("sets", new Gson().toJson(setList));
        return Arc.DEFAULT_ARC;
    }

    protected List<Map<String, String>> getSetList() {
        return (List)new Gson().fromJson(this.getSets(), List.class);
    }

    public String getSets() {
        return this.sets;
    }

    public void setSets(String sets) {
        this.sets = sets;
    }
}

