/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class PrepareStatsParamJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareStatsParamJobNode.class);
    private static final String xqueryIsLookupEndpoint = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IS_LookUpServiceResourceType']//PROTOCOL[./@name='SOAP']/@address/string()";
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource
    protected ConfigurationEnumerator configurationEnumerator;
    private String paramsMapJson;

    protected String execute(NodeToken token) throws Exception {
        log.info((Object)"prepare stats update job");
        Configuration conf = this.configurationEnumerator.get(ClusterName.DM);
        String nameNode = conf.get("fs.defaultFS");
        token.getEnv().setAttribute("nameNode", nameNode);
        token.getEnv().setAttribute("jobTracker", conf.get("mapred.job.tracker"));
        for (Map.Entry<String, String> e : this.asMap(this.getParamsMapJson()).entrySet()) {
            if (e.getKey().equals("oozieWfApplicationPath")) {
                token.getEnv().setAttribute(e.getKey(), nameNode + e.getValue());
                continue;
            }
            token.getEnv().setAttribute(e.getKey(), e.getValue());
        }
        token.getEnv().setAttribute("isLookupEndpoint", this.getIsLookupEndpoint());
        return Arc.DEFAULT_ARC;
    }

    private String getIsLookupEndpoint() throws ISLookUpDocumentNotFoundException, ISLookUpException {
        return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(xqueryIsLookupEndpoint);
    }

    private Map<String, String> asMap(String s) {
        return (Map)new Gson().fromJson(s, new TypeToken<Map<String, String>>(){}.getType());
    }

    public String getParamsMapJson() {
        return this.paramsMapJson;
    }

    public void setParamsMapJson(String paramsMapJson) {
        this.paramsMapJson = paramsMapJson;
    }
}

