/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.download;

import com.google.common.base.Function;
import eu.dnetlib.msro.openaireplus.workflows.nodes.download.LinkedObject;
import java.io.ByteArrayInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class URLGenerator
implements Function<String, String> {
    private final String dcNamespace = "http://purl.org/dc/elements/1.1/";
    private final XMLInputFactory factory = XMLInputFactory.newInstance();

    public String apply(String input) {
        try {
            LinkedObject object = new LinkedObject();
            XMLStreamReader parser = this.factory.createXMLStreamReader(new ByteArrayInputStream(input.getBytes()));
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1) continue;
                String name = parser.getLocalName();
                if ("identifier".equals(name)) {
                    String namespace = parser.getName().getNamespaceURI();
                    if (namespace != null) {
                        namespace = namespace.trim();
                    }
                    if (!"http://purl.org/dc/elements/1.1/".equals(namespace)) continue;
                    parser.next();
                    object.addURL(parser.getText().trim());
                    continue;
                }
                if (!"objIdentifier".equals(name)) continue;
                parser.next();
                object.setObjectIdentifier(parser.getText().trim());
            }
            return object.toJSON();
        }
        catch (XMLStreamException e) {
            return null;
        }
    }
}

