/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.dedup;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.openaireplus.workflows.nodes.hbase.SubmitHadoopJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DedupGrouperJobNode
extends SubmitHadoopJobNode {
    public static final int DEDUP_GROUPER_MAX_LOOPS = 10;
    public static final String DEDUP_GROUPER_LOOPER = "dedup.grouper.looper";
    public static final String DEDUP_GROUPER_CURR_WRITTEN_RELS = "dedup.grouper.written.rels";
    public static final String DEDUP_GROUPER_PREV_WRITTEN_RELS = "dedup.grouper.prev.written.rels";
    private static final Log log = LogFactory.getLog(DedupGrouperJobNode.class);

    private int currentIteration(NodeToken token) {
        try {
            String sTimes = token.getFullEnv().getAttribute(DEDUP_GROUPER_LOOPER);
            log.info((Object)("read dedup.grouper.looper from fullEnv: '" + sTimes + "'"));
            return Integer.parseInt(sTimes);
        }
        catch (NumberFormatException e) {
            log.info((Object)"got empty dedup.grouper.looper, initializing to 0");
            return 0;
        }
    }

    private boolean isStable(NodeToken token, String sCurr) {
        String sPrev = token.getFullEnv().getAttribute(DEDUP_GROUPER_PREV_WRITTEN_RELS);
        log.info((Object)("Comparing written rels, prev=" + sPrev + ", curr=" + sCurr));
        try {
            boolean b;
            boolean bl = b = Integer.parseInt(sCurr) == Integer.parseInt(sPrev);
            if (b) {
                log.info((Object)"  --- The number of written rels is STABLE");
            }
            return b;
        }
        catch (Exception e) {
            log.error((Object)("Invalid parsing of written rels counters - curr: " + sCurr + ", prev: " + sPrev));
            return false;
        }
    }

    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
        return new DedupBlackboardWorkflowJobListener(engine, token);
    }

    private class DedupBlackboardWorkflowJobListener
    extends BlackboardWorkflowJobListener {
        public DedupBlackboardWorkflowJobListener(Engine engine, NodeToken token) {
            super(engine, token);
        }

        protected void onDone(BlackboardJob job) {
            int times = DedupGrouperJobNode.this.currentIteration(this.getToken());
            String curr = (String)job.getParameters().get(DedupGrouperJobNode.DEDUP_GROUPER_CURR_WRITTEN_RELS);
            if (times == 0) {
                this.getToken().getFullEnv().setAttribute(DedupGrouperJobNode.DEDUP_GROUPER_PREV_WRITTEN_RELS, (Object)-1);
            }
            if (times >= 10 || DedupGrouperJobNode.this.isStable(this.getToken(), curr)) {
                super.complete(job, "done");
            } else {
                log.info((Object)("incrementing dedup.grouper.looper to " + (times + 1)));
                this.getToken().getFullEnv().setAttribute(DedupGrouperJobNode.DEDUP_GROUPER_LOOPER, (Object)(times + 1));
                this.getToken().getFullEnv().setAttribute(DedupGrouperJobNode.DEDUP_GROUPER_PREV_WRITTEN_RELS, curr);
                super.complete(job, Arc.DEFAULT_ARC);
            }
        }
    }
}

