/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.datacite;

import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.openaireplus.workflows.nodes.datacite.DataciteHostedByCounters;
import eu.dnetlib.msro.openaireplus.workflows.nodes.datacite.HostedByEntry;
import eu.dnetlib.msro.openaireplus.workflows.nodes.datacite.PatchHostedBy;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class DataciteHostedByJobNode
extends SimpleJobNode {
    private String inputEprParam;
    private String outputEprParam;
    private String dbName;
    private String countersParam;
    private ServiceLocator<DatabaseService> dbServiceLocator;
    private MappedResultSetFactory mappedResultSetFactory;
    private ResultSetClientFactory resultSetClientFactory;
    private static final Log log = LogFactory.getLog(DataciteHostedByJobNode.class);

    protected String execute(NodeToken token) throws Exception {
        W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(this.inputEprParam));
        DataciteHostedByCounters counters = new DataciteHostedByCounters();
        W3CEndpointReference epr = this.mappedResultSetFactory.createMappedResultSet(inputEpr, (UnaryFunction)new PatchHostedBy(this.loadHostedByMap(), counters));
        token.getEnv().setAttribute(this.outputEprParam, epr.toString());
        token.getEnv().setTransientAttribute(this.countersParam, (Object)counters);
        return Arc.DEFAULT_ARC;
    }

    private Map<String, HostedByEntry> loadHostedByMap() {
        HashMap map = Maps.newHashMap();
        try {
            String sql = "SELECT setspec, datasourceid, datasourcename FROM datacite_sets WHERE datasourceid IS NOT NULL";
            W3CEndpointReference epr = ((DatabaseService)this.dbServiceLocator.getService()).searchSQL(this.getDbName(), "SELECT setspec, datasourceid, datasourcename FROM datacite_sets WHERE datasourceid IS NOT NULL");
            SAXReader reader = new SAXReader();
            for (String s : this.resultSetClientFactory.getClient(epr)) {
                Document doc = reader.read((Reader)new StringReader(s));
                String set = doc.valueOf("//FIELD[@name='setspec']");
                String dsId = doc.valueOf("//FIELD[@name='datasourceid']");
                String dsName = doc.valueOf("//FIELD[@name='datasourcename']");
                map.put(set, new HostedByEntry(dsId, dsName));
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error calculating set->hostedBy map, ", e);
        }
        return map;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public ServiceLocator<DatabaseService> getDbServiceLocator() {
        return this.dbServiceLocator;
    }

    @Required
    public void setDbServiceLocator(ServiceLocator<DatabaseService> dbServiceLocator) {
        this.dbServiceLocator = dbServiceLocator;
    }

    public MappedResultSetFactory getMappedResultSetFactory() {
        return this.mappedResultSetFactory;
    }

    @Required
    public void setMappedResultSetFactory(MappedResultSetFactory mappedResultSetFactory) {
        this.mappedResultSetFactory = mappedResultSetFactory;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public String getCountersParam() {
        return this.countersParam;
    }

    public void setCountersParam(String countersParam) {
        this.countersParam = countersParam;
    }
}

