package eu.dnetlib.msro.openaireplus.workflows.nodes.objectStore;

import java.io.File;
import java.util.List;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.TrueFileFilter;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;

public class ImportFilesJobNode extends BlackboardJobNode implements ProgressJobNode {

	private String basePath;
	private String repositoryPrefix;
	private String oaiPrefix;
	private String objectStoreId;
	private String contentDescription;

	private ResultsetProgressProvider progressProvider;
	private ProcessCountingResultSetFactory processCountingResultSetFactory;
	private IterableResultSetFactory iterableResultSetFactory;

	public String getRepositoryPrefix() {
		return repositoryPrefix;
	}

	public void setRepositoryPrefix(final String repositoryPrefix) {
		this.repositoryPrefix = repositoryPrefix;
	}

	public String getBasePath() {
		return basePath;
	}

	public void setBasePath(final String basePath) {
		this.basePath = basePath;
	}

	@Override
	public ProgressProvider getProgressProvider() {
		return progressProvider;
	}

	@Override
	protected String getXqueryForServiceId(final NodeToken token) {
		return "//RESOURCE_IDENTIFIER[../RESOURCE_TYPE/@value='ObjectStoreServiceResourceType']/@value/string()";
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		File dir = new File(basePath);

		System.out.println("Getting all files in " + dir.getCanonicalPath() + " including those in subdirectories");
		List<File> files = (List<File>) FileUtils.listFiles(dir, TrueFileFilter.INSTANCE, TrueFileFilter.INSTANCE);
		IteratorRepository irepo;
		if (repositoryPrefix.equals("od________18")) {
			irepo = new ArxivIteratorRepository(files, repositoryPrefix, oaiPrefix);
		} else if (repositoryPrefix.equals("od______2367")) {
			irepo = new PUMAIteratorRepository(files, repositoryPrefix, oaiPrefix);
		} else {
			irepo = new RepositoryNoURLIterator(files, repositoryPrefix, oaiPrefix);
		}
		final W3CEndpointReference epr = iterableResultSetFactory.createIterableResultSet(irepo);
		this.progressProvider = processCountingResultSetFactory.createProgressProvider(token.getProcess(), epr);
		job.setAction("FEED");
		job.getParameters().put("obsID", getObjectStoreId());
		job.getParameters().put("mime", getContentDescription());
		job.getParameters().put("protocol", Protocols.File_System.toString());
		job.getParameters().put("epr", progressProvider.getEpr().toString());

	}

	public IterableResultSetFactory getIterableResultSetFactory() {
		return iterableResultSetFactory;
	}

	public void setIterableResultSetFactory(final IterableResultSetFactory iterableResultSetFactory) {
		this.iterableResultSetFactory = iterableResultSetFactory;
	}

	public void setProgressProvider(final ResultsetProgressProvider progressProvider) {
		this.progressProvider = progressProvider;
	}

	public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
		return processCountingResultSetFactory;
	}

	public void setProcessCountingResultSetFactory(final ProcessCountingResultSetFactory processCountingResultSetFactory) {
		this.processCountingResultSetFactory = processCountingResultSetFactory;
	}

	public String getObjectStoreId() {
		return objectStoreId;
	}

	public void setObjectStoreId(final String objectStoreId) {
		this.objectStoreId = objectStoreId;
	}

	public String getContentDescription() {
		return contentDescription;
	}

	public void setContentDescription(final String contentDescription) {
		this.contentDescription = contentDescription;
	}

	public String getOaiPrefix() {
		return oaiPrefix;
	}

	public void setOaiPrefix(final String oaiPrefix) {
		this.oaiPrefix = oaiPrefix;
	}
}
