package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import java.util.Map.Entry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public abstract class AbstractHBaseAdminJobNode extends SimpleJobNode {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(AbstractHBaseAdminJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String hbaseTableProperty;
	private String cluster;

	@Autowired
	protected ServiceLocator<HadoopService> hadoopServiceLocator;

	@Override
	protected void beforeStart(final NodeToken token) {
		for (Entry<String, String> e : parseJsonParameters(token).entrySet()) {
			token.getEnv().setAttribute(e.getKey(), e.getValue());
		}
	}

	protected String tableName(final NodeToken token) {
		if (token.getEnv().hasAttribute("hbaseTable")) {
			String table = token.getEnv().getAttribute("hbaseTable");
			log.info("found override value in wfEnv for 'hbaseTable' param: " + table);
			return table;
		}
		return getPropertyFetcher().getProperty(getHbaseTableProperty());
	}

	protected String cluster(final NodeToken token) {
		if (token.getEnv().hasAttribute("cluster")) {
			String cluster = token.getEnv().getAttribute("cluster");
			log.info("found override value in wfEnv for 'cluster' param: " + cluster);
			return cluster;
		}
		return getCluster();
	}

	public String getCluster() {
		return cluster;
	}

	public void setCluster(final String cluster) {
		this.cluster = cluster;
	}

	public String getHbaseTableProperty() {
		return hbaseTableProperty;
	}

	public void setHbaseTableProperty(final String hbaseTableProperty) {
		this.hbaseTableProperty = hbaseTableProperty;
	}

}
