package eu.dnetlib.msro.openaireplus.workflows.nodes.download;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;

public class DownloadFromMetadataJobNode extends BlackboardJobNode implements ProgressJobNode {

	private String objectStoreId;
	private String contentDescription;
	private String inputEprParam;

	private ResultsetProgressProvider progressProvider;
	private ProcessCountingResultSetFactory processCountingResultSetFactory;
	private IterableResultSetFactory iterableResultSetFactory;

	@Override
	public ProgressProvider getProgressProvider() {
		return progressProvider;
	}

	@Override
	protected String getXqueryForServiceId(final NodeToken token) {
		return "//RESOURCE_IDENTIFIER[../RESOURCE_TYPE/@value='ObjectStoreServiceResourceType']/@value/string()";
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		final W3CEndpointReference inputEpr = (new EPRUtils()).getEpr(token.getEnv().getAttribute(inputEprParam));
		this.progressProvider = processCountingResultSetFactory.createProgressProvider(token.getProcess(), inputEpr);
		job.setAction("FEED");
		job.getParameters().put("obsID", getObjectStoreId());
		job.getParameters().put("mime", getContentDescription());
		job.getParameters().put("protocol", Protocols.HTTP.toString());
		job.getParameters().put("epr", progressProvider.getEpr().toString());

	}

	public IterableResultSetFactory getIterableResultSetFactory() {
		return iterableResultSetFactory;
	}

	public void setIterableResultSetFactory(final IterableResultSetFactory iterableResultSetFactory) {
		this.iterableResultSetFactory = iterableResultSetFactory;
	}

	public void setProgressProvider(final ResultsetProgressProvider progressProvider) {
		this.progressProvider = progressProvider;
	}

	public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
		return processCountingResultSetFactory;
	}

	public void setProcessCountingResultSetFactory(final ProcessCountingResultSetFactory processCountingResultSetFactory) {
		this.processCountingResultSetFactory = processCountingResultSetFactory;
	}

	public String getObjectStoreId() {
		return objectStoreId;
	}

	public void setObjectStoreId(final String objectStoreId) {
		this.objectStoreId = objectStoreId;
	}

	public String getContentDescription() {
		return contentDescription;
	}

	public void setContentDescription(final String contentDescription) {
		this.contentDescription = contentDescription;
	}

	public String getInputEprParam() {
		return inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

}
