package eu.dnetlib.msro.openaireplus.workflows.nodes.claims;

import java.io.StringReader;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.openaireplus.workflows.nodes.SetHdfsFileJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class DecapsuleClaimsJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(SetHdfsFileJobNode.class);

	private static final Namespace OAF_NS = new Namespace("oaf", "http://namespace.openaire.eu/oaf");
	private static final double DEFAULT_TRUST = 0.9;

	private String inputEprParam;
	private String outputEprParam;

	@Resource
	private MappedResultSetFactory mappedResultSetFactory;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final UnaryFunction<String, String> mapper = new UnaryFunction<String, String>() {

			final SAXReader reader = new SAXReader();

			@Override
			public String evaluate(final String row) {
				try {
					final Document docRow = reader.read(new StringReader(row));

					final String xml = docRow.valueOf("//ROW/FIELD[@name = 'xml']");
					final String provenance = docRow.valueOf("//ROW/FIELD[@name = 'provenance']");

					final Document doc = reader.read(new StringReader(xml));
					final Element record = (Element) doc.selectSingleNode("//*[local-name() = 'record']");
					final Element about = record.addElement(new QName("about"));
					final Element dataInfo = about.addElement(new QName("datainfo", OAF_NS));

					dataInfo.addElement(new QName("inferred", OAF_NS)).setText("false");
					dataInfo.addElement(new QName("deletedbyinference", OAF_NS)).setText("false");
					dataInfo.addElement(new QName("trust", OAF_NS)).setText(Double.toString(DEFAULT_TRUST));
					dataInfo.addElement(new QName("inferenceprovenance", OAF_NS)).setText("");

					final Element action = dataInfo.addElement(new QName("provenanceaction", OAF_NS));
					action.addAttribute("schemename", "dnet:provenanceActions");
					action.addAttribute("schemeid", "dnet:provenanceActions");
					action.addAttribute("classname", provenance);
					action.addAttribute("classid", provenance);

					return doc.asXML();
				} catch (Throwable e) {
					log.error("Error parsing row: " + row, e);
					throw new IllegalArgumentException("Error parsing row: " + row, e);
				}
			}
		};

		final W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(getInputEprParam()));
		final W3CEndpointReference epr = mappedResultSetFactory.createMappedResultSet(inputEpr, mapper);

		token.getEnv().setAttribute(getOutputEprParam(), epr.toString());

		return Arc.DEFAULT_ARC;
	}

	public String getInputEprParam() {
		return inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

}
