package eu.dnetlib.msro.openaireplus.workflows.nodes.actions;

import java.io.StringReader;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class UpdateSetsJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(UpdateSetsJobNode.class);

	@Resource(name = "lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;

	@Resource(name = "registryLocator")
	private ServiceLocator<ISRegistryService> registryLocator;

	@Override
	protected String execute(NodeToken token) throws Exception {

		@SuppressWarnings("unchecked")
		final List<Map<String, String>> sets = new Gson().fromJson(token.getEnv().getAttribute("sets"), List.class);

		final String lastUpdate = DateUtils.now_ISO8601();
		for (Map<String, String> set : sets) {
			log.info("updating set: " + set.toString());
			addLatestRawSet(set, lastUpdate);
		}

		return Arc.DEFAULT_ARC;
	}

	public void addLatestRawSet(final Map<String, String> set, final String lastUpdate) throws MSROException {
		final String q = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') where $x//SET/@id = '" + set.get("set")
				+ "' return $x";
		try {
			final String profile = lookupLocator.getService().getResourceProfileByQuery(q);
			final Document doc = new SAXReader().read(new StringReader(profile));
			final String profId = doc.valueOf("//RESOURCE_IDENTIFIER/@value");
			final Element latest = (Element) doc.selectSingleNode("//RAW_SETS/LATEST");
			final Element expired = ((Element) doc.selectSingleNode("//RAW_SETS")).addElement("EXPIRED");

			for (Object o : latest.attributes()) {
				final Attribute a = (Attribute) o;
				expired.addAttribute(a.getName(), a.getValue());
			}

			latest.addAttribute("id", set.get("rawset"));
			latest.addAttribute("creationDate", set.get("creationDate"));
			latest.addAttribute("lastUpdate", lastUpdate);

			registryLocator.getService().updateProfile(profId, doc.asXML(), "ActionManagerSetDSResourceType");
		} catch (Exception e) {
			String msg = "Error updating profile of set: " + set;
			log.error(msg);
			throw new MSROException(msg, e);
		}
	}

}
