package eu.dnetlib.msro.openaireplus.workflows.nodes;

import java.util.Map;
import java.util.Map.Entry;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class PrepareStatsParamJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(PrepareStatsParamJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private static final String xqueryIsLookupEndpoint =
			"//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IS_LookUpServiceResourceType']//PROTOCOL[./@name='SOAP']/@address/string()";

	@Resource(name = "lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;

	@Resource
	protected ConfigurationEnumerator configurationEnumerator;

	private String paramsMapJson;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		log.info("prepare stats update job");

		Configuration conf = configurationEnumerator.get(ClusterName.DM);
		String nameNode = conf.get("fs.defaultFS");

		token.getEnv().setAttribute("nameNode", nameNode);
		token.getEnv().setAttribute("jobTracker", conf.get("mapred.job.tracker"));

		for (Entry<String, String> e : asMap(getParamsMapJson()).entrySet()) {
			if (e.getKey().equals("oozieWfApplicationPath")) {
				token.getEnv().setAttribute(e.getKey(), nameNode + e.getValue());
			} else {
				token.getEnv().setAttribute(e.getKey(), e.getValue());
			}
		}

		// token.getEnv().setAttribute("ContextResourceXML", getContextProfiles());
		token.getEnv().setAttribute("isLookupEndpoint", getIsLookupEndpoint());

		return Arc.DEFAULT_ARC;
	}

	private String getIsLookupEndpoint() throws ISLookUpDocumentNotFoundException, ISLookUpException {
		return lookupLocator.getService().getResourceProfileByQuery(xqueryIsLookupEndpoint);
	}

	private Map<String, String> asMap(final String s) {
		return new Gson().fromJson(s, new TypeToken<Map<String, String>>() {}.getType());
	}

	// protected String getContextProfiles() throws ISLookUpException {
	// StringBuilder sb = new StringBuilder("<RESOURCE_PROFILES>");
	// sb.append(Joiner.on("").skipNulls().join(lookupLocator.getService().quickSearchProfile(getXqueryForContextProfiles())));
	// sb.append("</RESOURCE_PROFILES>");
	// return sb.toString();
	// }

	public String getParamsMapJson() {
		return paramsMapJson;
	}

	public void setParamsMapJson(final String paramsMapJson) {
		this.paramsMapJson = paramsMapJson;
	}

}
