package eu.dnetlib.msro.openaireplus.workflows.nodes;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class FindComplianceRepositoriesJobNode extends SimpleJobNode {

	private String dbName;

	// The following files are in "dnet-openaireplus-datasource-manager-service" module
	private final Resource sqlSelectDatasourcesTmpl = new ClassPathResource("/eu/dnetlib/enabling/datasources/getDatasources.sql.st");
	private final Resource xsltFile = new ClassPathResource("/eu/dnetlib/enabling/datasources/repo_2_is.xslt");

	private String eprParam = "repoEpr";

	private ServiceLocator<DatabaseService> dbServiceLocator;

	private XSLTMappedResultSetFactory xsltMappedResultSetFactory;

	private static final Log log = LogFactory.getLog(FindComplianceRepositoriesJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final StringTemplate st = new StringTemplate(IOUtils.toString(sqlSelectDatasourcesTmpl.getInputStream()));
		// st.setAttribute(
		// "condition",
		// "datasourceclass = 'entityregistry' OR (openairecompatibilityclass IS NOT null AND openairecompatibilityclass != 'UNKNOWN' AND openairecompatibilityclass != 'notCompatible')");
		final String sql = st.toString();
		final String xslt = IOUtils.toString(xsltFile.getInputStream());

		log.debug("Executing query: " + sql);

		final W3CEndpointReference epr = dbServiceLocator.getService().searchSQL(dbName, sql);
		final W3CEndpointReference mapped = xsltMappedResultSetFactory.createMappedResultSet(epr, xslt);

		token.getEnv().setTransientAttribute(getEprParam(), mapped);

		return Arc.DEFAULT_ARC;
	}

	public String getDbName() {
		return dbName;
	}

	public void setDbName(final String dbName) {
		this.dbName = dbName;
	}

	public ServiceLocator<DatabaseService> getDbServiceLocator() {
		return dbServiceLocator;
	}

	@Required
	public void setDbServiceLocator(final ServiceLocator<DatabaseService> dbServiceLocator) {
		this.dbServiceLocator = dbServiceLocator;
	}

	public XSLTMappedResultSetFactory getXsltMappedResultSetFactory() {
		return xsltMappedResultSetFactory;
	}

	public void setXsltMappedResultSetFactory(final XSLTMappedResultSetFactory xsltMappedResultSetFactory) {
		this.xsltMappedResultSetFactory = xsltMappedResultSetFactory;
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

}
