package eu.dnetlib.functionality.modular.ui.workflows.values;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;

public class ListHadoopClusters extends ValidNodeValuesFetcher {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(ListHadoopClusters.class);

	/** The hadoop locator. */
	@Resource(name = "dynamicHadoopServiceLocator")
	private ServiceLocator<HadoopService> hadoopLocator;

	private Function<String, DnetParamValue> f = new Function<String, DnetParamValue>() {

		@Override
		public DnetParamValue apply(final String s) {
			return new DnetParamValue(s, s);
		}
	};

	@Override
	protected List<DnetParamValue> obtainValues(final Map<String, String> params) throws Exception {

		List<DnetParamValue> res = Lists.newArrayList(Iterables.transform(listClusters(), f));
		return res;
	}

	private List<String> listClusters() {
		try {
			return hadoopLocator.getService().listClusters();
		} catch (Throwable e) {
			log.error(e);
			return Lists.newArrayList();
		}
	}
}
