 <NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="COLLECT"/>
	</ARCS>
</NODE>

<NODE name="COLLECT" type="QueryDb">
	<DESCRIPTION>Collect claims from DB</DESCRIPTION>
	<PARAMETERS>
		<PARAM name="dbProperty" type="string" managedBy="system" required="true">dnet.openaire.db.name</PARAM>
		<PARAM name="sql" type="string" managedBy="system" required="true">/eu/dnetlib/msro/openaireplus/workflows/db/queryClaimsDmf.sql</PARAM>
		<PARAM name="outputEprParam" type="string" managedBy="system" required="true">collected_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="DECAPSULE" />
	</ARCS>
</NODE>	


<NODE name="DECAPSULE" type="ApplyXslt">
	<DESCRIPTION>Prepare mdstore records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="xsltClasspath" managedBy="system">/eu/dnetlib/msro/openaireplus/workflows/db/decapsule_claims_dmf.xsl</PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">collected_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">store_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="STORE"/>
	</ARCS>
</NODE>

<NODE name="STORE" type="StoreMDStoreRecords">
	<DESCRIPTION>Store mdtore records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("harv_id")$</PARAM>
		<PARAM required="true" type="string" name="storingType" managedBy="user">REFRESH</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">store_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
 