/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.oai;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrepareOaiDataJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareOaiDataJobNode.class);
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String outputRecordsPathParam;
    private String rottenRecordsPathParam;
    private String hbaseTable;
    private String oaiStoreCollectionParam;
    private String format;

    protected String execute(NodeToken token) throws Exception {
        log.info((Object)"start preparing job");
        token.getEnv().setAttribute(this.getOutputRecordsPathParam(), "/tmp" + this.getFileName(token, "indexrecords"));
        token.getEnv().setAttribute(this.getRottenRecordsPathParam(), "/tmp" + this.getFileName(token, "oairottenrecords"));
        token.getEnv().setAttribute(this.getOaiStoreCollectionParam(), "oaf-openaire-index");
        String configurationProfile = this.getConfigurationProfile();
        token.getEnv().setAttribute("oaiConfiguration", configurationProfile);
        token.getEnv().setAttribute("oai.feed.date", DateUtils.now_ISO8601());
        return Arc.DEFAULT_ARC;
    }

    private String getConfigurationProfile() throws MSROException {
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']");
        }
        catch (Exception e) {
            throw new MSROException("Cannot find OAI configuration profile", (Throwable)e);
        }
    }

    private String getFileName(NodeToken token, String fileNamePrefix) {
        return "/" + fileNamePrefix + "_" + this.getHbaseTable() + "_" + this.getFormat() + ".seq";
    }

    public String getOutputRecordsPathParam() {
        return this.outputRecordsPathParam;
    }

    public void setOutputRecordsPathParam(String outputRecordsPathParam) {
        this.outputRecordsPathParam = outputRecordsPathParam;
    }

    public String getRottenRecordsPathParam() {
        return this.rottenRecordsPathParam;
    }

    public void setRottenRecordsPathParam(String rottenRecordsPathParam) {
        this.rottenRecordsPathParam = rottenRecordsPathParam;
    }

    public String getHbaseTable() {
        return this.hbaseTable;
    }

    public void setHbaseTable(String hbaseTable) {
        this.hbaseTable = hbaseTable;
    }

    public String getOaiStoreCollectionParam() {
        return this.oaiStoreCollectionParam;
    }

    public void setOaiStoreCollectionParam(String oaiStoreCollectionParam) {
        this.oaiStoreCollectionParam = oaiStoreCollectionParam;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

